/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core;

import com.aptana.core.IURIMapper;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.URLEncoder;
import com.aptana.debug.core.IActiveResourcePathGetterAdapter;
import com.aptana.debug.core.internal.Util;
import com.aptana.debug.core.util.DebugUtil;
import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.core.Messages;
import com.aptana.js.debug.core.internal.ProtocolLogger;
import com.aptana.js.debug.core.internal.browsers.BrowserUtil;
import com.aptana.js.debug.core.internal.browsers.Firefox;
import com.aptana.js.debug.core.internal.browsers.InternetExplorer;
import com.aptana.js.debug.core.internal.model.DebugConnection;
import com.aptana.js.debug.core.internal.model.JSDebugProcess;
import com.aptana.js.debug.core.internal.model.JSDebugTarget;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.SimpleWebServer;
import com.aptana.webserver.core.URLtoURIMapper;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.core.WorkspaceResolvingURIMapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected static final IStatus launchBrowserPromptStatus = new Status(1, "com.aptana.js.debug.core", 302, "", null);
    private static Listener checkFirefoxLocationListener;

    public static void setCheckFirefoxLocationListener(Listener listener) {
        checkFirefoxLocationListener = listener;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String browserExecutable;
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
        boolean debug = "debug".equals(mode);
        if (debug) {
            IDebugTarget activeSession = null;
            IDebugTarget[] iDebugTargetArray = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget target = iDebugTargetArray[n2];
                if ("com.aptana.js.debug.core".equals(target.getModelIdentifier()) && !target.isTerminated()) {
                    activeSession = target;
                    break;
                }
                ++n2;
            }
            if (activeSession != null) {
                Object result = prompter.handleStatus(launchBrowserPromptStatus, null);
                if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                    activeSession.terminate();
                    while (!monitor.isCanceled() && !activeSession.isTerminated()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } else {
                    String errorMessage = String.valueOf(Messages.JSLaunchConfigurationDelegate_MultipleJavaScriptDebugNotSupported) + Messages.JSLaunchConfigurationDelegate_PleaseTerminateActiveSession;
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 4, errorMessage, null));
                }
            }
        }
        if ((browserExecutable = configuration.getAttribute("browserExecutable", null)) == null || !new File(browserExecutable).exists()) {
            boolean found = false;
            String name = configuration.getName();
            if (!StringUtil.isEmpty((String)name) && name.startsWith("Firefox")) {
                if (checkFirefoxLocationListener == null) {
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    JSLaunchConfigurationHelper.setBrowserDefaults(wc, null);
                    browserExecutable = wc.getAttribute("browserExecutable", null);
                } else {
                    browserExecutable = checkFirefoxLocationListener.checkFirefoxLocation();
                }
                if (StringUtil.isEmpty((String)browserExecutable)) {
                    return;
                }
                if (new File(browserExecutable).exists()) {
                    found = true;
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("browserExecutable", browserExecutable);
                    wc.doSave();
                }
            }
            if (!found) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, MessageFormat.format(Messages.JSLaunchConfigurationDelegate_WebBrowserDoesNotExist, browserExecutable), null));
            }
        }
        JSLaunchConfigurationHelper.initializeLaunchAttributes(configuration, launch);
        boolean debugCompatible = BrowserUtil.isBrowserDebugCompatible(browserExecutable);
        boolean debugAvailable = false;
        boolean advancedRun = configuration.getAttribute("advancedRunEnabled", false);
        if (debugCompatible && (debug || advancedRun)) {
            monitor.subTask(Messages.JSLaunchConfigurationDelegate_CheckingBrowserForDebugger);
            debugAvailable = BrowserUtil.isBrowserDebugAvailable(browserExecutable);
            if (!debugAvailable) {
                if (!BrowserUtil.installDebugExtension(browserExecutable, prompter, monitor)) {
                    monitor.setCanceled(true);
                    return;
                }
                debugAvailable = BrowserUtil.isBrowserDebugAvailable(browserExecutable);
            }
            if (debug && !debugAvailable) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_DebuggerExtensionNotInstalled, null));
            }
        }
        int serverType = configuration.getAttribute("serverType", 1);
        int startActionType = configuration.getAttribute("startActionType", 1);
        boolean appendProjectName = configuration.getAttribute("appendProjectName", false);
        URL launchURL = null;
        IServer urlMapper = null;
        try {
            IResource startResource = null;
            IPath startPath = null;
            switch (startActionType) {
                case 1: {
                    startResource = this.getCurrentEditorResource();
                    if (startResource != null || (startPath = this.getCurrentEditorPath()) != null || (launchURL = this.getCurrentEditorURL()) != null) break;
                    monitor.setCanceled(true);
                    return;
                }
                case 2: {
                    String resourcePath = configuration.getAttribute("startPagePath", null);
                    if (resourcePath == null || resourcePath.length() <= 0) break;
                    startResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(resourcePath));
                    break;
                }
                case 3: {
                    launchURL = new URL(configuration.getAttribute("startPageUrl", ""));
                }
            }
            if (startResource == null && startPath == null && launchURL == null) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchURLNotDefined, null));
            }
            if (launchURL != null) {
                if (launchURL.toExternalForm().endsWith(".js") && InternetExplorer.isBrowserExecutable(browserExecutable)) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 4, Messages.JSLaunchConfigurationDelegate_Cannot_Debug_JS_File, null));
                }
            } else if (serverType == 1) {
                IServer server = WebServerCorePlugin.getDefault().getBuiltinWebServer();
                ((SimpleWebServer)server).setDocumentRoot(EFSUtils.getFileStore((IResource)ResourcesPlugin.getWorkspace().getRoot()).toURI());
                this.startServerIfNecessary(server, mode, monitor);
                urlMapper = server;
            } else if (serverType == 2) {
                String serverName = configuration.getAttribute("serverName", null);
                if (serverName != null) {
                    IServer server = WebServerCorePlugin.getDefault().getServerManager().findServerByName(serverName);
                    this.startServerIfNecessary(server, mode, monitor);
                    urlMapper = server;
                }
                if (urlMapper == null) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, MessageFormat.format(Messages.JSLaunchConfigurationDelegate_ServerNotFound0_Error, serverName), null));
                }
                if (startResource != null) {
                    urlMapper = new WorkspaceResolvingURIMapper((IURIMapper)urlMapper);
                }
            } else if (serverType == 3) {
                String externalBaseUrl = configuration.getAttribute("externalBaseUrl", "").trim();
                if (StringUtil.isEmpty((String)externalBaseUrl)) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_Empty_URL, null));
                }
                if (externalBaseUrl.charAt(externalBaseUrl.length() - 1) != '/') {
                    externalBaseUrl = String.valueOf(externalBaseUrl) + '/';
                }
                if (startResource != null) {
                    IFileStore rootFileStore = EFSUtils.getFileStore((IResource)(appendProjectName ? ResourcesPlugin.getWorkspace().getRoot() : startResource.getProject()));
                    urlMapper = new URLtoURIMapper(new URL(externalBaseUrl), rootFileStore.toURI());
                }
            } else {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_No_Server_Type, null));
            }
            if (urlMapper != null) {
                if (startResource != null) {
                    launchURL = Util.toURL((URI)urlMapper.resolve(EFSUtils.getFileStore((IResource)startResource)));
                } else if (startPath != null && (launchURL = Util.toURL((URI)urlMapper.resolve(EFSUtils.getLocalFileStore((File)startPath.toFile())))) == null) {
                    launchURL = startPath.toFile().toURI().toURL();
                }
            } else if (launchURL == null && startPath != null) {
                launchURL = startPath.toFile().toURI().toURL();
            }
            if (launchURL == null) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchURLNotDefined, null));
            }
            String httpGetQuery = configuration.getAttribute("httpGetData", "");
            if (httpGetQuery != null && httpGetQuery.length() > 0 && launchURL.getQuery() == null && launchURL.getRef() == null) {
                if (httpGetQuery.charAt(0) != '?') {
                    httpGetQuery = String.valueOf('?') + httpGetQuery;
                }
                launchURL = new URL(launchURL, String.valueOf(launchURL.getFile()) + httpGetQuery);
            }
            launchURL = new URL(launchURL, URLEncoder.encode((String)launchURL.getPath(), (String)launchURL.getQuery(), (String)launchURL.getRef()));
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_MalformedServerURL, (Throwable)e));
        }
        monitor.subTask(Messages.JSLaunchConfigurationDelegate_LaunchingBrowser);
        Process process = null;
        ArrayList<String> browserArgs = new ArrayList<String>();
        String browserCmdLine = configuration.getAttribute("browserCmdLine", "");
        if (browserCmdLine != null && browserCmdLine.length() > 0) {
            String[] stringArray = browserCmdLine.split(" ");
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String arg = stringArray[n3];
                if (arg.trim().length() > 0) {
                    browserArgs.add(arg.trim());
                }
                ++n3;
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        if (debugAvailable) {
            Socket socket;
            block103: {
                int port = DebugUtil.getDebuggerPort();
                ServerSocket listenSocket = null;
                try {
                    listenSocket = DebugUtil.allocateServerSocket((int)port);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_SocketConnectionError, (Throwable)e));
                }
                String debuggerLaunchUrl = "http://www.aptana.com/?debugger=true&port=" + Integer.toString(port);
                try {
                    if ("macosx".equals(Platform.getOS())) {
                        args.add("/usr/bin/open");
                        args.add("-b");
                        args.add(BrowserUtil.getMacOSXApplicationIdentifier(browserExecutable));
                        args.add(debuggerLaunchUrl);
                    } else if (InternetExplorer.isBrowserExecutable(browserExecutable)) {
                        args.add(browserExecutable);
                        args.add(debuggerLaunchUrl);
                    } else {
                        args.add(browserExecutable);
                        args.add(debuggerLaunchUrl);
                    }
                    if ("true".equals(Platform.getDebugOption((String)"com.aptana.debug.core/debugger_debug"))) {
                        args = null;
                    }
                    if (args != null) {
                        args.addAll(browserArgs);
                        process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
                    }
                }
                catch (IOException e) {
                    if (listenSocket != null) {
                        try {
                            listenSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        listenSocket = null;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchProcessError, (Throwable)e));
                }
                socket = null;
                try {
                    try {
                        monitor.subTask(MessageFormat.format(Messages.JSLaunchConfigurationDelegate_OpeningSocketOnPort, port));
                        socket = listenSocket.accept();
                    }
                    catch (IOException e) {
                        BrowserUtil.resetBrowserCache(browserExecutable);
                        if (debug && !monitor.isCanceled()) {
                            throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_SocketConnectionError, (Throwable)e));
                        }
                        if (listenSocket != null) {
                            try {
                                listenSocket.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block103;
                    }
                }
                catch (Throwable throwable) {
                    if (listenSocket != null) {
                        try {
                            listenSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (listenSocket != null) {
                    try {
                        listenSocket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (socket != null) {
                monitor.subTask(Messages.JSLaunchConfigurationDelegate_InitializingDebugger);
                JSDebugTarget debugTarget = null;
                try {
                    JSDebugProcess debugProcess = new JSDebugProcess(launch, browserExecutable, null);
                    DebugConnection controller = DebugConnection.createConnection(socket, new ProtocolLogger("jsdebugger", "com.aptana.js.debug.core"));
                    debugTarget = new JSDebugTarget(launch, debugProcess, (IURIMapper)urlMapper, controller, mode);
                    monitor.subTask(MessageFormat.format(Messages.JSLaunchConfigurationDelegate_OpeningPage, launchURL));
                    debugTarget.openURL(launchURL);
                }
                catch (CoreException e) {
                    JSDebugPlugin.log(e);
                    if (debugTarget != null) {
                        debugTarget.terminate();
                    } else {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
            }
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)browserExecutable);
        } else if ("run".equals(mode)) {
            try {
                String launchPage = launchURL.toExternalForm();
                if ("macosx".equals(Platform.getOS())) {
                    args.add("/usr/bin/open");
                    args.add("-b");
                    args.add(BrowserUtil.getMacOSXApplicationIdentifier(browserExecutable));
                    args.add(launchPage);
                } else {
                    args.add(browserExecutable);
                    if (debugCompatible && Firefox.isBrowserExecutable(browserExecutable)) {
                        if (advancedRun) {
                            args.add("-new-window");
                            browserArgs.remove("-new-window");
                            browserArgs.remove("-new-tab");
                        } else {
                            if (browserArgs.contains("-new-window")) {
                                args.add("-new-window");
                            } else {
                                args.add("-new-tab");
                            }
                            browserArgs.remove("-new-window");
                            browserArgs.remove("-new-tab");
                        }
                    }
                    args.add(launchPage);
                }
                args.addAll(browserArgs);
                process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, Messages.JSLaunchConfigurationDelegate_LaunchProcessError, (Throwable)e));
            }
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)browserExecutable);
        } else {
            throw new CoreException((IStatus)new Status(4, "com.aptana.js.debug.core", 0, MessageFormat.format(Messages.JSLaunchConfigurationDelegate_ConfiguredBrowserDoesNotSupportDebugging, browserExecutable), null));
        }
    }

    protected void startServerIfNecessary(IServer server, String mode, IProgressMonitor monitor) throws CoreException {
        IStatus result;
        if ("run".equals(mode) && server.getState() != IServer.State.STARTED && server.getState() != IServer.State.STARTING && !(result = server.start(mode, monitor)).isOK()) {
            throw new CoreException(result);
        }
    }

    protected IResource getCurrentEditorResource() throws MalformedURLException {
        IActiveResourcePathGetterAdapter adapter = (IActiveResourcePathGetterAdapter)this.getContributedAdapter(IActiveResourcePathGetterAdapter.class);
        if (adapter != null) {
            return adapter.getActiveResource();
        }
        return null;
    }

    protected IPath getCurrentEditorPath() throws MalformedURLException {
        IActiveResourcePathGetterAdapter adapter = (IActiveResourcePathGetterAdapter)this.getContributedAdapter(IActiveResourcePathGetterAdapter.class);
        if (adapter != null) {
            return adapter.getActiveResourcePath();
        }
        return null;
    }

    protected URL getCurrentEditorURL() throws MalformedURLException {
        IActiveResourcePathGetterAdapter adapter = (IActiveResourcePathGetterAdapter)this.getContributedAdapter(IActiveResourcePathGetterAdapter.class);
        if (adapter != null) {
            return adapter.getActiveResourceURL();
        }
        return null;
    }

    protected Object getContributedAdapter(Class<?> clazz) {
        Object adapter = null;
        IAdapterManager manager = Platform.getAdapterManager();
        if (manager.hasAdapter((Object)this, clazz.getName()) && (adapter = manager.getAdapter((Object)this, clazz.getName())) == null) {
            adapter = manager.loadAdapter((Object)this, clazz.getName());
        }
        return adapter;
    }

    public static interface Listener {
        public String checkFirefoxLocation();
    }
}

